/*:
 * @target MZ
 * @plugindesc マウスの画面上のピクセル座標を常時指定した変数に格納するプラグイン
 * @author あなたの名前
 *
 * @param XVariableId
 * @text X座標を格納する変数ID
 * @type variable
 * @default 1
 *
 * @param YVariableId
 * @text Y座標を格納する変数ID
 * @type variable
 * @default 2
 *
 * @help
 * このプラグインは、マウスカーソルの画面上のピクセル座標(X, Y)を
 * 常に指定した変数に格納します。
 *
 * ◆使い方：
 * プラグインパラメータでXとYそれぞれの座標を格納する変数IDを設定してください。
 * このプラグインは自動的に動作します。
 *
 * ◆注意：
 * - マウス座標は「画面上のピクセル単位の位置（Graphics.boxX/Yを考慮）」です。
 * - タッチ操作にも対応しています。
 *
 * このプラグインにはプラグインコマンドはありません。
 */

(() => {
  const pluginName = "MousePositionToVariable";

  const parameters = PluginManager.parameters(pluginName);
  const xVarId = Number(parameters["XVariableId"] || 1);
  const yVarId = Number(parameters["YVariableId"] || 2);

  const _MousePosVar_update = SceneManager.updateMain;
  SceneManager.updateMain = function() {
    _MousePosVar_update.call(this);
    const x = TouchInput.x;
    const y = TouchInput.y;
    if ($gameVariables) {
      $gameVariables.setValue(xVarId, x);
      $gameVariables.setValue(yVarId, y);
    }
  };
})();
